/********************************************************************************
 		Remote Control State Machine
		Mauro Grassi May 2008 for Musicolour BETA ver 8.0 and above
 		based on code by Peter Smith
		Infrared receive state machine (must be called every 64us)
*********************************************************************************/
#ifndef	_IR_H
#define _IR_H

#include "types.h"
#include "common.h"
#include "integer.h"
#include "p33FJ64GP802.h"

#define IR_RXD	(PORTBbits.RB5)
#define IR_LED	(LED3)

/*
RC5 Specification Periods:
short pulse	889s	444s	1333s
short space	889s	444s	1333s
long pulse	1778s	1334s	2222s
long space	1778s	1334s	2222s
*/

#define KEY_BUFFER_SIZE     4
#define THIRTY_ONE      	31
#define SEVENTY_EIGHT   	78
#define THIRTY_FIVE     	35
#define TWENTY_ONE      	21
#define	REMOTE_CONTROL_DEFS_ADDRESS 0
#define MAGIC_REMOTE_CONTROL_VALUE  0x76
#define JAYCARLCD_ADDR				100
// Menus
#define KEYZERO 	        0
#define KEYONE		        1
#define KEYTWO	        	2
#define KEYTHREE	        3
#define KEYFOUR		        4
#define KEYFIVE	        	5
#define KEYSIX		        6
#define KEYSEVEN	        7
#define KEYEIGHT        	8
#define KEYNINE		        9
#define KEYVOLUP	        10
#define KEYVOLDOWN	        11
#define KEYMODEUP	        12
#define KEYMODEDOWN	        13
#define KEYMENU		        14
#define KEYSTOP				15
#define KEYPLAY		        16
#define KEYPAUSE	        17
#define KEYFF		        18
#define KEYREWIND	        19
#define KEYRECORD			20
#define KEYOK				21
#define KEYEXIT				22
#define KEYLINE				23
#define IRKEYS 		        24

extern BYTE keyFull;
extern BYTE keyGetPtr;
extern BYTE keyPtr;
extern unsigned int keyBuffer[KEY_BUFFER_SIZE];
extern unsigned int ir_timer;
extern BYTE ir_state, ir_bit_cnt;
extern unsigned int ir_cmd, ir_code;
extern BYTE ir_rpt;
extern BYTE ir_rdy;

extern void initRC5(void);
extern int ir_receive(void);
extern unsigned int translateIRCode(unsigned int);
extern int ReadEEPROM(BYTE);
extern BYTE WriteEEPROM(BYTE, BYTE);
extern void initKeys(void);
extern unsigned int getKey(void);
extern void putKey(unsigned int);
void readRemoteControlCodes(void);
void writeRemoteControlCodes(void);
unsigned int keyCodeDefined(unsigned int, int);
void defineDefaultRemoteControl(void);
void reDefineRemoteControlCodes(void);

#endif


